/****************************************************************************
*                                                                           *
* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY     *
* KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE       *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR     *
* PURPOSE.                                                                  *
*                                                                           *
* Copyright(C) 1997-98 by PSH //UCL.                                        *
*                                                                           *
*****************************************************************************
*                                                                           *
* This is Main File of Soft-Pro HASP Emulator                               *
*                                                                           *
****************************************************************************/

#define HASP_EMU_95

#define WANTVXDWRAPS

#include <basedef.h>
#include <vmm.h>
#include <debug.h>
#include <vmmreg.h>
#include <vxdwraps.h>
#include <vwin32.h>
#include <winerror.h>

#include "..\common\emucrypt.h"
#include "..\common\haspdata.h"
#include "..\common\haspfile.h"
#include "..\common\emuver.h"

#define HASP95_VERSION	0x400
#define HASP95F1		1
#define HASP95F2		2

typedef DIOCPARAMETERS *LPDIOC;
typedef char *PSTR;

#pragma VxD_LOCKED_CODE_SEG
#pragma VxD_LOCKED_DATA_SEG


// HASP File Header
EMU_HASP_DATA *HASPHeader;

// HASP Memory
unsigned short int *HASPMem;

char *DUMPFile;
char *DUMP;
char *DUMPPath;
char *LogFile;
DWORD LogLevel;
DWORD WriteMode;

DWORD cbIn, cbOut; // Sizes of input and output buffers
PSTR  lpIn, lpOut; // Pointers to input and output buffers

DWORD _stdcall HASPFunc2(LPDIOC lpDIOCtl);
DWORD _stdcall HASPFunc1(LPDIOC lpDIOCtl);

void HASP_EMU(HASPData *HASP);
int LoadConfig(void);
void UnLoadConfig(void);

//
// Prototypes
//

DWORD _stdcall HASP95EMU_DeviceIOControl(DWORD, DWORD, DWORD, LPDIOC);


/****************************************************************************
                  HASP95_DeviceIOControl
****************************************************************************/
DWORD _stdcall HASP95EMU_DeviceIOControl(DWORD  dwService,
                                        DWORD  dwDDB,
                                        DWORD  hDevice,
                                        LPDIOC lpDIOCParms)
{
    DWORD dwRetVal = 0;

	switch(dwService)
	{
	// Device Open
	case DIOC_OPEN: break;

	// Device Close
	case DIOC_CLOSEHANDLE:break;

	// HASP VxD Function 1
	case HASP95F1:HASPFunc1(lpDIOCParms);break;

	// HASP VxD Function 1
	case HASP95F2:HASPFunc2(lpDIOCParms);break;

	// Default - Error (Not Supported)
	default: dwRetVal = ERROR_NOT_SUPPORTED;
	}
    return(dwRetVal);
}

// Main Function of VxD
DWORD _stdcall HASPFunc2(LPDIOC lpDIOCtl)
{

// VxD - Program exchange buffer
HASPData HASP;

	// Not need in this version
//	lpIn = (PSTR)lpDIOCtl->lpvInBuffer;
//    	cbIn = lpDIOCtl->cbInBuffer;

	// Out Buffer
        lpOut = (PSTR)lpDIOCtl->lpvOutBuffer;
    	cbOut = lpDIOCtl->cbOutBuffer;

/***************************************************************************
* Bug Here !                                                               *
****************************************************************************
* Need check cbOut (must be 0x54)                                          *
***************************************************************************/
        
	// Decrypt (skip some dword)
	DecryptBuffer(lpOut+4,&HASP);

	// Emulate HASP !
        HASP_EMU(&HASP);

	// Encrypt (skip some dword)
        EncryptBuffer(&HASP,lpOut+4);

	// Bytes Returned
	lpDIOCtl->lpcbBytesReturned=0x54;

// All OK
return(0);
}

/****************************************************************************
* Load Configuration                                                        *
*****************************************************************************
* Params: None                                                              *
*****************************************************************************
* Return: int - status (0 - OK, -1 - Error)                                 *
****************************************************************************/
int LoadConfig(void)
{
DWORD Opened;
VMMHKEY RegKey;
DWORD Type;
DWORD Size;

// Allocate Memory For Buffers
HASPHeader=_HeapAllocate(sizeof(EMU_HASP_DATA),HEAPZEROINIT);
DUMPFile=_HeapAllocate(512,HEAPZEROINIT);
LogFile=_HeapAllocate(512,HEAPZEROINIT);
DUMP=_HeapAllocate(512,HEAPZEROINIT);
DUMPPath=_HeapAllocate(512,HEAPZEROINIT);
HASPMem=_HeapAllocate(512,HEAPZEROINIT);

// Full Name in VxD File
EMUStrLen(FULL_EMU_NAME);

// Check buffers
if (!LogFile || !DUMPPath || !HASPHeader || !DUMPFile || !DUMP || !HASPMem)
      return -1;

// if Demo - Decrypt Dump
#ifdef HASP_EMU_DEMO

if (DecryptDemoDumpBuffer()!=0)
      return -1;

#endif

// if not Demo
#ifndef HASP_EMU_DEMO

// Open RegKey
Opened=_RegOpenKey(HKEY_LOCAL_MACHINE,"SOFTWARE\\Soft-Pro\\HASP Emulator",&RegKey);


// Load Keys
if (Opened == ERROR_SUCCESS)
{
Size=512;
if (_RegQueryValueEx(RegKey,"KeyDir",NULL,&Type,(unsigned char *)DUMPPath,&Size)!=ERROR_SUCCESS)
	DUMPPath[0]=0;
	else
	if (Type != REG_SZ)
		DUMPPath[0]=0;

Size=512;
if (_RegQueryValueEx(RegKey,"LogFile",NULL,&Type,(unsigned char *)LogFile,&Size)!=ERROR_SUCCESS)
	LogFile[0]=0;
	else
	if (Type != REG_SZ)
		LogFile[0]=0;

Size=sizeof(DWORD);
if (_RegQueryValueEx(RegKey,"LogLevel",NULL,&Type,(unsigned char *)&LogLevel,&Size)!=ERROR_SUCCESS)
	LogLevel=0;
	else
	if (Type != 4)
		LogLevel=0;

Size=sizeof(DWORD);
if (_RegQueryValueEx(RegKey,"WriteMode",NULL,&Type,(unsigned char *)&WriteMode,&Size)!=ERROR_SUCCESS)
	WriteMode=0;
	else
	if (Type != 4)
		WriteMode=0;
}

// Close RegKey
_RegCloseKey(RegKey);

// If not loaded path for dumps or regkey not opened
if ((DUMPPath[0]==0) || (Opened != ERROR_SUCCESS)) 
	{
	_HeapFree(HASPHeader,0);
	_HeapFree(DUMPFile,0);
	_HeapFree(LogFile,0);
	_HeapFree(DUMP,0);
	_HeapFree(DUMPPath,0);
	_HeapFree(HASPMem,0);
	return -1;
	}

#endif

return 0;
}

/****************************************************************************
* HASP Function for 16 bit Apps                                             *
*****************************************************************************
* Params: None                                                              *
*****************************************************************************
* Return: None                                                              *
****************************************************************************/
void HASP16(HASPData *HASP)
{

// Decrypt Buffer
Decrypt16((unsigned char *)HASP);

// Emulate HASP !
HASP_EMU(HASP);

// Encrypt Buffer
Encrypt16((unsigned char *)HASP);
}


/****************************************************************************
* Some VxD Function                                                         *
* May be test VxD ?                                                         *
****************************************************************************/
DWORD _stdcall HASPFunc1(LPDIOC lpDIOCtl)
{
	int n;
    lpIn = (PSTR)lpDIOCtl->lpvInBuffer;
    cbIn = lpDIOCtl->cbInBuffer;

    lpOut = (PSTR)lpDIOCtl->lpvOutBuffer;
    cbOut = lpDIOCtl->cbOutBuffer;

	for(n=0;n<cbOut;n++)
		lpOut[n]=lpIn[0];

lpDIOCtl->lpcbBytesReturned=0x54;

return(0);
}



DWORD _stdcall HASP95EMU_Dynamic_Exit(void)
{
return(VXD_SUCCESS);
}



#pragma VxD_ICODE_SEG
#pragma VxD_IDATA_SEG

DWORD _stdcall HASP95EMU_Dynamic_Init(void)
{
return(VXD_SUCCESS);
}
